<?php
/*======================================================================*\
|| #################################################################### ||
|| # vBulletin 3.7.0 Beta 5 - Licence Number DGT-SERIAL
|| # ---------------------------------------------------------------- # ||
|| # Copyright ©2000-2008 Jelsoft Enterprises Ltd. All Rights Reserved. ||
|| # This file may not be redistributed in whole or significant part. # ||
|| # ---------------- VBULLETIN IS NOT FREE SOFTWARE ---------------- # ||
|| # http://www.vbulletin.com | http://www.vbulletin.com/license.html # ||
|| #################################################################### ||
\*======================================================================*/

// ####################### SET PHP ENVIRONMENT ###########################
error_reporting(E_ALL & ~E_NOTICE);

// #################### DEFINE IMPORTANT CONSTANTS #######################
if ($_REQUEST['do'] == 'inlinemerge' OR $_POST['do'] == 'doinlinemerge')
{
	define('GET_EDIT_TEMPLATES', true);
}
define('THIS_SCRIPT', 'picturecomment_inlinemod');

// ################### PRE-CACHE TEMPLATES AND DATA ######################
// get special phrase groups
$phrasegroups = array('threadmanage', 'posting', 'inlinemod');

// get special data templates from the datastore
$specialtemplates = array();

$globaltemplates = array(
	'threadadmin_authenticate'
);

$actiontemplates = array(
	'inlinedelete' => array('picturecomment_deletemessages')
);

// ######################### REQUIRE BACK-END ############################
require_once('./global.php');
require_once(DIR . '/includes/functions_picturecomment.php');
require_once(DIR . '/includes/modfunctions.php');

// #######################################################################
// ######################## START MAIN SCRIPT ############################
// #######################################################################

if (!$vbulletin->options['pc_enabled'])
{
	print_no_permission();
}

$itemlimit = 200;

// This is a list of ids that were checked on the page we submitted from
$vbulletin->input->clean_array_gpc('p', array(
	'picturecommentlist' => TYPE_ARRAY_KEYS_INT,
	'pictureid'          => TYPE_UINT,
));

$vbulletin->input->clean_array_gpc('c', array(
	'vbulletin_inlinepicturecomment' => TYPE_STR,
));

if (!empty($vbulletin->GPC['vbulletin_inlinepicturecomment']))
{
	$commentlist = explode('-', $vbulletin->GPC['vbulletin_inlinepicturecomment']);
	$commentlist = $vbulletin->input->clean($commentlist, TYPE_ARRAY_UINT);

	$vbulletin->GPC['picturecommentlist'] = array_unique(array_merge($commentlist, $vbulletin->GPC['picturecommentlist']));
}

if (!$vbulletin->userinfo['userid'])
{
	print_no_permission();
}

switch ($_POST['do'])
{
	case 'doinlinedelete':
	{
		$inline_mod_authenticate = true;
		break;
	}
	default:
	{
		$inline_mod_authenticate = false;
		($hook = vBulletinHook::fetch_hook('picturecomment_inlinemod_authenticate_switch')) ? eval($hook) : false;
	}
}

if ($inline_mod_authenticate AND !inlinemod_authenticated())
{
	show_inline_mod_login();
}

switch ($_POST['do'])
{
	case 'inlinedelete':
	case 'inlineapprove':
	case 'inlineunapprove':
	case 'inlineundelete':

		if (empty($vbulletin->GPC['picturecommentlist']))
		{
			standard_error(fetch_error('you_did_not_select_any_valid_messages'));
		}

		if (count($vbulletin->GPC['picturecommentlist']) > $itemlimit)
		{
			standard_error(fetch_error('you_are_limited_to_working_with_x_messages', $itemlimit));
		}

		$messageids = implode(', ', $vbulletin->GPC['picturecommentlist']);
		break;

	case 'doinlinedelete':

		$vbulletin->input->clean_array_gpc('p', array(
			'messageids' => TYPE_STR,
		));
		$messageids = explode(',', $vbulletin->GPC['messageids']);
		$messageids = $vbulletin->input->clean($messageids, TYPE_ARRAY_UINT);

		if (count($messageids) > $itemlimit)
		{
			standard_error(fetch_error('you_are_limited_to_working_with_x_messages', $itemlimit));
		}
		break;
}

// set forceredirect for IIS
$forceredirect = (strpos($_SERVER['SERVER_SOFTWARE'], 'Microsoft-IIS') !== false);

$messagelist = $messagearray = $userlist = array();

($hook = vBulletinHook::fetch_hook('picturecomment_inlinemod_start')) ? eval($hook) : false;

if ($_POST['do'] == 'clearmessage')
{
	setcookie('vbulletin_inlinepicturecomment', '', TIMENOW - 3600, '/');

	eval(print_standard_redirect('redirect_inline_messagelist_cleared', true, $forceredirect));
}

if ($_POST['do'] == 'inlineapprove' OR $_POST['do'] == 'inlineunapprove')
{
	$insertrecords = array();

	$approve = ($_POST['do'] == 'inlineapprove');

	// Validate Messages
	$messages = $db->query_read_slave("
		SELECT picturecomment.*, picture.userid AS picture_userid
		FROM " . TABLE_PREFIX . "picturecomment AS picturecomment
		INNER JOIN " . TABLE_PREFIX . "picture AS picture ON (picture.pictureid = picturecomment.pictureid)
		WHERE picturecomment.commentid IN ($messageids)
			AND picturecomment.state IN (" . ($approve ? "'moderation'" : "'visible', 'deleted'") . ")
	");
	while ($message = $db->fetch_array($messages))
	{
		$pictureinfo = array(
			'pictureid' => $message['pictureid'],
			'userid' => $message['picture_userid']
		);

		if ($message['state'] == 'deleted' AND !can_moderate(0, 'candeletepicturecomments'))
		{
			standard_error(fetch_error('you_do_not_have_permission_to_manage_deleted_messages'));
		}
		else if (!fetch_user_picture_message_perm('canmoderatemessages', $pictureinfo, $message))
		{
			standard_error(fetch_error('you_do_not_have_permission_to_moderate_messages'));
		}

		$messagearray["$message[commentid]"] = $message;
		$userlist["$pictureinfo[userid]"] = true;

		if (!$approve)
		{
			$insertrecords[] = "($message[commentid], 'picturecomment', " . TIMENOW . ")";
		}
	}

	if (empty($messagearray))
	{
		standard_error(fetch_error('you_did_not_select_any_valid_messages'));
	}

	// Set message state
	$db->query_write("
		UPDATE " . TABLE_PREFIX . "picturecomment
		SET state = '" . ($approve ? 'visible' : 'moderation') . "'
		WHERE commentid IN (" . implode(',', array_keys($messagearray)) . ")
	");

	if ($approve)
	{
		$db->query_write("
			DELETE FROM " . TABLE_PREFIX . "moderation
			WHERE primaryid IN(" . implode(',', array_keys($messagearray)) . ")
				AND type = 'picturecomment'
		");
	}
	else	// Unapprove
	{
		$db->query_write("
			REPLACE INTO " . TABLE_PREFIX . "moderation
				(primaryid, type, dateline)
			VALUES
				" . implode(',', $insertrecords) . "
		");

		$db->query_write("
			DELETE FROM " . TABLE_PREFIX . "deletionlog
			WHERE type = 'picturecomment' AND
				primaryid IN(" . implode(',', array_keys($messagearray)) . ")
		");
	}

	foreach (array_keys($userlist) AS $userid)
	{
		build_picture_comment_counters($userid);
	}

	setcookie('vbulletin_inlinepicturecomment', '', TIMENOW - 3600, '/');

	($hook = vBulletinHook::fetch_hook('picturecomment_inlinemod_approveunapprove')) ? eval($hook) : false;

	if ($approve)
	{
		eval(print_standard_redirect('redirect_inline_approvedmessages', true, $forceredirect));
	}
	else
	{
		eval(print_standard_redirect('redirect_inline_unapprovedmessages', true, $forceredirect));
	}
}

if ($_POST['do'] == 'inlinedelete')
{
	$show['removemessagets'] = false;
	$show['deletemessages'] = false;
	$show['deleteoption'] = false;
	$checked = array('delete' => 'checked="checked"');
	$picturelist = array();

	// Validate Messages
	$messages = $db->query_read_slave("
		SELECT picturecomment.*, picture.userid AS picture_userid
		FROM " . TABLE_PREFIX . "picturecomment AS picturecomment
		INNER JOIN " . TABLE_PREFIX . "picture AS picture ON (picture.pictureid = picturecomment.pictureid)
		WHERE picturecomment.commentid IN ($messageids)
	");
	while ($message = $db->fetch_array($messages))
	{
		$pictureinfo = array(
			'pictureid' => $message['pictureid'],
			'userid' => $message['picture_userid']
		);

		$canmoderatemessages = fetch_user_picture_message_perm('canmoderatemessages', $pictureinfo, $message);
		$candeletemessages = fetch_user_picture_message_perm('candeletemessages', $pictureinfo, $message);
		$canremovemessages = can_moderate(0, 'canremovepicturecomments');

		if ($message['state'] == 'moderation' AND !$canmoderatemessages)
		{
			standard_error(fetch_error('you_do_not_have_permission_to_manage_moderated_messages'));
		}
		else if ($message['state'] == 'deleted' AND !$candeletemessages)
		{
			standard_error(fetch_error('you_do_not_have_permission_to_manage_deleted_messages'));
		}
		else
		{
			$show['deletemessages'] = $candeletemessages;
			if ($canremovemessages)
			{
				$show['removemessages'] = true;
				if (!$candeletemessages)
				{
					$checked = array('remove' => 'checked="checked"');
				}
			}

			if (!$candeletemessages AND !$canremovemessages)
			{
				standard_error(fetch_error('you_do_not_have_permission_to_delete_messages'));
			}
			else if ($candeletemessages AND $canremovemessages)
			{
				$show['deleteoption'] = true;
			}
		}

		$messagearray["$message[commentid]"] = $message;
		$picturelist["$message[pictureid]"] = true;
		$userlist["$pictureinfo[userid]"] = true;
	}

	if (empty($messagearray))
	{
		standard_error(fetch_error('you_did_not_select_any_valid_messages'));
	}

	$messagecount = count($messagearray);
	$picturecount = count($picturelist);

	$url =& $vbulletin->url;

	$navbits = array('' => $vbphrase['delete_messages']);
	$navbits = construct_navbits($navbits);
	eval('$navbar = "' . fetch_template('navbar') . '";');

	($hook = vBulletinHook::fetch_hook('picturecomment_inlinemod_delete')) ? eval($hook) : false;

	eval('print_output("' . fetch_template('picturecomment_deletemessages') . '");');

}

if ($_POST['do'] == 'doinlinedelete')
{

	$vbulletin->input->clean_array_gpc('p', array(
		'deletetype'   => TYPE_UINT, // 1 - Soft Deletion, 2 - Physically Remove
		'deletereason' => TYPE_NOHTMLCOND,
	));

	$physicaldel = ($vbulletin->GPC['deletetype'] == 2) ? true : false;

	// Validate Messages
	$messages = $db->query_read_slave("
		SELECT picturecomment.*, picture.userid AS picture_userid
		FROM " . TABLE_PREFIX . "picturecomment AS picturecomment
		INNER JOIN " . TABLE_PREFIX . "picture AS picture ON (picture.pictureid = picturecomment.pictureid)
		WHERE picturecomment.commentid IN (" . implode(',', $messageids) . ")
	");
	while ($message = $db->fetch_array($messages))
	{
		$pictureinfo = array(
			'pictureid' => $message['pictureid'],
			'userid' => $message['picture_userid']
		);

		$canmoderatemessages = fetch_user_picture_message_perm('canmoderatemessages', $pictureinfo, $message);
		$candeletemessages = fetch_user_picture_message_perm('candeletemessages', $pictureinfo, $message);
		$canremovemessages = can_moderate(0, 'canremovepicturecomments');

		if ($message['state'] == 'moderation' AND !$canmoderatemessages)
		{
			standard_error(fetch_error('you_do_not_have_permission_to_manage_moderated_messages'));
		}
		else if ($message['state'] == 'deleted' AND !$candeletemessages)
		{
			standard_error(fetch_error('you_do_not_have_permission_to_manage_deleted_messages'));
		}
		else
		{
			if (($physicaldel AND !$canremovemessages) OR (!$physicaldel AND !$candeletemessages))
			{
				standard_error(fetch_error('you_do_not_have_permission_to_delete_messages'));
			}
		}

		$messagearray["$message[commentid]"] = $message;
		$userlist["$pictureinfo[userid]"] = true;
	}

	if (empty($messagearray))
	{
		standard_error(fetch_error('you_did_not_select_any_valid_messages'));
	}

	foreach($messagearray AS $commentid => $message)
	{
		$dataman =& datamanager_init('PictureComment', $vbulletin, ERRTYPE_SILENT);
		$dataman->set_existing($message);
		$dataman->set_info('hard_delete', $physicaldel);
		$dataman->set_info('reason', $vbulletin->GPC['deletereason']);
		$dataman->delete();
		unset($dataman);
	}

	foreach(array_keys($userlist) AS $userid)
	{
		build_picture_comment_counters($userid);
	}

	// empty cookie
	setcookie('vbulletin_inlinepicturecomment', '', TIMENOW - 3600, '/');

	($hook = vBulletinHook::fetch_hook('picturecomment_inlinemod_dodelete')) ? eval($hook) : false;

	eval(print_standard_redirect('redirect_inline_deletedmessages', true, $forceredirect));
}

if ($_POST['do'] == 'inlineundelete')
{
	// Validate Messages
	$messages = $db->query_read_slave("
		SELECT picturecomment.*, picture.userid AS picture_userid
		FROM " . TABLE_PREFIX . "picturecomment AS picturecomment
		INNER JOIN " . TABLE_PREFIX . "picture AS picture ON (picture.pictureid = picturecomment.pictureid)
		WHERE picturecomment.commentid IN ($messageids)
			AND picturecomment.state = 'deleted'
	");
	while ($message = $db->fetch_array($messages))
	{
		$pictureinfo = array(
			'pictureid' => $message['pictureid'],
			'userid' => $message['picture_userid']
		);
		if (!can_moderate(0, 'candeletepicturecomments'))
		{
			standard_error(fetch_error('you_do_not_have_permission_to_manage_deleted_messages'));
		}

		$messagearray["$message[commentid]"] = $message;
		$userlist["$pictureinfo[userid]"] = true;
	}

	if (empty($messagearray))
	{
		standard_error(fetch_error('you_did_not_select_any_valid_messages'));
	}

	$db->query_write("
		DELETE FROM " . TABLE_PREFIX . "deletionlog
		WHERE type = 'picturecomment' AND
			primaryid IN(" . implode(',', array_keys($messagearray)) . ")
	");
	$db->query_write("
		UPDATE " . TABLE_PREFIX . "picturecomment
		SET state = 'visible'
		WHERE commentid IN(" . implode(',', array_keys($messagearray)) . ")
	");

	foreach(array_keys($userlist) AS $userid)
	{
		build_picture_comment_counters($userid);
	}

	// empty cookie
	setcookie('vbulletin_inlinepicturecomment', '', TIMENOW - 3600, '/');

	($hook = vBulletinHook::fetch_hook('picturecomment_inlinemod_undelete')) ? eval($hook) : false;

	eval(print_standard_redirect('redirect_inline_undeletedmessages', true, $forceredirect));
}

/*======================================================================*\
|| ####################################################################
|| # Downloaded: DGT-DATE
|| # SVN: $Revision: 25678 $
|| ####################################################################
\*======================================================================*/
